import { FiEdit, FiDownload, FiLayers } from "react-icons/fi";
import { Tooltip } from "react-tooltip";
import { encryptId } from "@/app/actions/encrypt";
export const getEDAColumns = (router, rows = [], setEDAReviewModalOpen, setChapterId) => {
  // Check if any row has a non-empty stage_movements array
  const hasStageMovements = rows.some(
    (row) => Array.isArray(row.stage_movements) && row.stage_movements.length > 0
  );

  const columns = [
    {
      label: "S.No",
      name: "S.No",
      cell: (row, index) => index + 1,
    },
    {
      label: "Book Title",
      name: "Book Title",
      selector: (row) => row.book.book_title,
    },
    {
      label: "Manuscript ID",
      name: "Manuscript ID",
      selector: (row) => row.chap_manuscriptID,
    },
    {
      label: "Chapter Title",
      name: "Chapter Title",
      selector: (row) => row.chap_title,
      styleTypeUiPatterns: "badge",
    },
    {
      label: "Author",
      name: "Author",
      cell: (row) => `${row.chap_firstName} ${row.chap_lastName}`,
      styleTypeUiPatterns: "badge",
    },
    {
      label: "Email",
      name: "Email",
      selector: (row) => row.chap_corresAuEmail,
    },
    // {
    //     label: "Status",
    //     name: "Status",
    //     selector: (row) => row.chap_status,
    //     styleTypeUiPatterns: "badge",
    // },
    // {
    //     label: "P+ Status",
    //     name: "P+ Status",
    //     selector: (row) => row.pstatus?.pstatus_name || "",
    //     styleTypeUiPatterns: "badge",
    // },
    // {
    //     label: "Due Date",
    //     name: "Due Date",
    //     selector: (row) => row.chap_pdueDate,
    //     styleTypeUiPatterns: "badge",
    // },
    {
      label: "Copy Editing",
      name: "Copy Editing",
      selector: (row) => row.chap_copyEditing,
      styleTypeUiPatterns: "badge",
      styleTypeColors: "warning",
    },
    {
      label: "Comments",
      name: "Comments",
      selector: (row) => row.chap_comments,
      grow: 2,
      wrap: true,
    },
    ...(hasStageMovements
      ? [
        {
          label: "FQC Send Date",
          name: "FQC Send Date",
          cell: (row) => row.stage_movements?.[0]?.stage_dispachDate || "",
        },
        {
          label: "FQC Send File",
          name: "FQC Send File",
          cell: (row) => {
            const fileName = row.stage_movements?.[0]?.stage_uploadFile;
            if (!fileName) return "";

            return (
              <a
                href={`/First_check/${fileName}`} // Replace with your actual file path or URL
                download={fileName}            // Forces download
                className="flex items-center gap-1 text-blue-600 hover:text-blue-800"
              >
                <FiDownload size={16} />
                {fileName}
              </a>
            );
          },
        },

        {
          label: "FQC Send Comments",
          name: "FQC Send Comments",
          cell: (row) => row.stage_movements?.[0]?.stage_notes || "",
          grow: 2,
          wrap: true,
        },
      ]
      : []),
    {
      label: "Action",
      name: "Action",
      cell: (row) => (
        <div className="flex space-x-3">
          <button
            onClick={() => {
              setEDAReviewModalOpen(true);
              setChapterId(row.chap_pid);
            }}
            aria-label="EDA Review"
            data-tooltip-id={`EDA-tooltip-${row.chap_pid}`}
            data-tooltip-content="EDA Review"
            className="text-green-600 hover:text-green-800 cursor-pointer"
            type="button"
          >
            <FiEdit size={20} />
            <Tooltip
              id={`EDA-tooltip-${row.chap_pid}`}
              place="bottom"
              style={{
                backgroundColor: "#10B981",
                color: "#fff",
                fontSize: "12px",
                borderRadius: "4px",
                padding: "6px 10px",
              }}
            />
          </button>
          <button
            // onClick={() => router.push(`/stage_movements/${row.chap_pid}`)}
            onClick={async () => {
                  try {
                      const encryptedId = await encryptId(row.chap_pid);
                      router.push(`/stage_movements/${encryptedId}`);
                  } catch (error) {
                      console.error('Encryption failed:', error);
                  }
              }}
            data-tooltip-id={`edit-tooltip-${row.chap_pid}`}
            data-tooltip-content="View Stage movements"
            className="text-blue-600 hover:text-blue-800 cursor-pointer"
            type="button"
          >
            <FiLayers size={20} />
            <Tooltip
              id={`edit-tooltip-${row.chap_pid}`}
              place="bottom"
              style={{
                backgroundColor: "#3b82f6",
                color: "#fff",
                fontSize: "12px",
                borderRadius: "4px",
                padding: "6px 10px",
              }}
            />
          </button>
        </div>
      ),
      ignoreRowClick: true,
    },
  ];

  return columns;
};
